// Created by inigo quilez - iq/2014
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
};


float2x2 m = float2x2(  0.80, 0.60, 
					   -0.60, 0.80 );

float hash( float2 p )
{
	float h = dot(p,float2(127.1,311.7));
    return -1.0 + 2.0*frac(sin(h)*43758.5453123);
}

float noise( in float2 p )
{
    float2 i = floor( p );
    float2 f = frac( p );
	
	float2 u = f*f*(3.0-2.0*f);

    return lerp( lerp( hash( i + float2(0.0,0.0) ), 
                       hash( i + float2(1.0,0.0) ), u.x),
                 lerp( hash( i + float2(0.0,1.0) ), 
                       hash( i + float2(1.0,1.0) ), u.x), u.y);
}

float fbm( float2 p )
{
    float f = 0.0;
    f += 0.5000*noise( p ); p = mul(m,p*2.02);
    f += 0.2500*noise( p ); p = mul(m,p*2.03);
    f += 0.1250*noise( p ); p = mul(m,p*2.01);
    f += 0.0625*noise( p );
    return f/0.9375;
}

float2 fbm2( in float2 p )
{
    return float2( fbm(p.xy), fbm(p.yx) );
}

float3 map( float2 p )
{   
    p *= 0.7;

    float f = dot( fbm2( 1.0*(0.05*time + p + fbm2(-0.05*time+2.0*(p + fbm2(4.0*p)))) ), float2(1.0,-1.0) );

    float bl = smoothstep( -0.8, 0.8, f );

    float ti = smoothstep( -1.0, 1.0, fbm(p) );

    return lerp( lerp( float3(0.50,0.00,0.00), 
                     float3(1.00,0.75,0.35), ti ), 
                     float3(0.00,0.00,0.02), bl );
}
struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float2 p = (-1+2.0*In.TexCd.xy);
    p.x *=  R.x / R.y;

    float e = 0.0045;

    float3 colc = map( p                 ); float gc = dot(colc,float(0.333));
    float3 cola = map( p + float2(e,0.0) ); float ga = dot(cola,float(0.333));
    float3 colb = map( p + float2(0.0,e) ); float gb = dot(colb,float(0.333));
    
    float3 nor = normalize( float3(ga-gc, e, gb-gc ) );

    float3 col = colc;
    col += float3(1.0,0.7,0.6)*8.0*abs(2.0*gc-ga-gb);
    col *= 1.0+0.2*nor.y*nor.y;
    col += 0.05*nor.y*nor.y*nor.y;
    return float4( col, 1.0 );
}


technique10 WarpingProcedural
{
	pass P0
	{
		SetVertexShader( CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



